/*
** Zabbix
** Copyright (C) 2001-2024 Zabbix SIA
**
** Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
** documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
** rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
** permit persons to whom the Software is furnished to do so, subject to the following conditions:
**
** The above copyright notice and this permission notice shall be included in all copies or substantial portions
** of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
** WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
** COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
** TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
** SOFTWARE.
**/

package container

import "golang.zabbix.com/sdk/plugin"

type emptyCtx struct {
	resultWriter emptyResultWriter
	matcher      emptyMatcher
}

type emptyMatcher struct{}

type emptyResultWriter struct{}

func (ctx emptyCtx) ClientID() uint64 {
	return 0
}

func (ctx emptyCtx) ItemID() uint64 {
	return 0
}

func (ctx emptyCtx) Output() plugin.ResultWriter {
	return ctx.resultWriter
}

func (ctx emptyCtx) Meta() *plugin.Meta {
	return nil
}

func (ctx emptyCtx) GlobalRegexp() plugin.RegexpMatcher {
	return ctx.matcher
}

func (ctx emptyCtx) Delay() string {
	return ""
}

func (em emptyMatcher) Match(value, pattern string, mode int, output_template *string) (bool, string) {
	return false, ""
}

func (emptyResultWriter) Write(*plugin.Result)       {}
func (emptyResultWriter) Flush()                     {}
func (emptyResultWriter) SlotsAvailable() int        { return 0 }
func (emptyResultWriter) PersistSlotsAvailable() int { return 0 }
