% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest.R
\name{unnest}
\alias{unnest}
\title{Unnest a list column.}
\usage{
unnest(data, ..., .drop = NA, .id = NULL, .sep = NULL,
  .preserve = NULL)
}
\arguments{
\item{data}{A data frame.}

\item{...}{Specification of columns to unnest. Use bare variable names or
functions of variables. If omitted, defaults to all list-cols.}

\item{.drop}{Should additional list columns be dropped? By default,
\code{unnest} will drop them if unnesting the specified columns requires
the rows to be duplicated.}

\item{.id}{Data frame identifier - if supplied, will create a new column
with name \code{.id}, giving a unique identifier. This is most useful if
the list column is named.}

\item{.sep}{If non-\code{NULL}, the names of unnested data frame columns
will combine the name of the original list-col with the names from
nested data frame, separated by \code{.sep}.}

\item{.preserve}{Optionally, list-columns to preserve in the output. These
will be duplicated in the same way as atomic vectors. This has
\link[dplyr:select]{dplyr::select} semantics so you can preserve multiple variables with
\code{.preserve = c(x, y)} or \code{.preserve = starts_with("list")}.}
}
\description{
If you have a list-column, this makes each element of the list its own
row. \code{unnest()} can handle list-columns that contain atomic vectors, lists, or
data frames (but not a mixture of the different types).
}
\details{
If you unnest multiple columns, parallel entries must have the same length
or number of rows (if a data frame).
}
\examples{
library(dplyr)
df <- tibble(
  x = 1:3,
  y = c("a", "d,e,f", "g,h")
)
df \%>\%
  transform(y = strsplit(y, ",")) \%>\%
  unnest(y)

# Or just
df \%>\%
  unnest(y = strsplit(y, ","))

# It also works if you have a column that contains other data frames!
df <- tibble(
  x = 1:2,
  y = list(
   tibble(z = 1),
   tibble(z = 3:4)
 )
)
df \%>\% unnest(y)

# You can also unnest multiple columns simultaneously
df <- tibble(
 a = list(c("a", "b"), "c"),
 b = list(1:2, 3),
 c = c(11, 22)
)
df \%>\% unnest(a, b)
# If you omit the column names, it'll unnest all list-cols
df \%>\% unnest()

# You can also choose to preserve one or more list-cols
df \%>\% unnest(a, .preserve = b)

# Nest and unnest are inverses
df <- data.frame(x = c(1, 1, 2), y = 3:1)
df \%>\% nest(y)
df \%>\% nest(y) \%>\% unnest()

# If you have a named list-column, you may want to supply .id
df <- tibble(
  x = 1:2,
  y = list(a = 1, b = 3:4)
)
unnest(df, .id = "name")
}
\seealso{
\code{\link[=nest]{nest()}} for the inverse operation.
}
