% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gargle-oauth-client.R
\name{gargle_client}
\alias{gargle_client}
\title{OAuth client for demonstration purposes}
\usage{
gargle_client(type = NULL)
}
\arguments{
\item{type}{Specifies the type of OAuth client. The valid values are a subset
of possible Google client types and reflect the key used to describe the
client in its JSON representation:
\itemize{
\item \code{"installed"} is associated with a "Desktop app"
\item \code{"web"} is associated with a "Web application"
}}
}
\value{
An OAuth client, produced by \code{\link[=gargle_oauth_client]{gargle_oauth_client()}}, invisibly.
}
\description{
Invisibly returns an instance of
\code{\link[=gargle_oauth_client]{gargle_oauth_client}} that can be used to test drive
gargle before obtaining your own client ID and secret. This OAuth client may
be deleted or rotated at any time. There are no guarantees about which APIs
are enabled. DO NOT USE THIS IN A PACKAGE or for anything other than
interactive, small-scale experimentation.

You can get your own OAuth client ID and secret, without these limitations.
See the \code{vignette("get-api-credentials")} for more details.
}
\examples{
\dontrun{
gargle_client()
}
}
\keyword{internal}
