//**************************************************************************************************
//                                          DlgPrefs.hpp                                           *
//                                         --------------                                          *
// Description : This dialogue is used to enter applications preferences.                          *
// Started     : 2006-10-17                                                                        *
// Last Update : 2015-04-18                                                                        *
// Copyright   : (C) 2006 by MSWaters                                                              *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef DLGPREFS_HPP
#define DLGPREFS_HPP

// Application Includes

#include "TypeDefs.hpp"
#include "CmdLinePcr.hpp"
#include "utility/PnlValue.hpp"
#include "utility/TextCtrl.hpp"
#include "utility/PnlLblCho.hpp"
#include "utility/PnlLblTxt.hpp"
#include "utility/PnlTxtSpn.hpp"

// wxWidgets Includes

#include <wx/config.h>

//**************************************************************************************************

class DlgPrefs : public wxDialog
{
  private :

    // Pointer to global configuration object
    wxConfig  * m_poCfg;

    // Display controls
    PnlLblCho   m_oChoViewerUtil;
    PnlLblCho   m_oChoTmpFileMgt;
    PnlLblCho   m_oChoFrmLayout;
    PnlLblCho   m_oChoUnitsPhase;
    PnlLblCho   m_oChoPrecision;
    PnlValue    m_oPnlNbkMaxLns;
    PnlValue    m_oPnlSpnPeriod;
//  PnlLblCho   m_oPnlTipDelay;    // ??? MSW 2015-03-23 Tool tip delay
    wxCheckBox  m_oCbxToolTips;
    wxCheckBox  m_oCbxSyncSwpSrcs;
//  wxCheckBox  m_oCbxSubcktCpnts; // ??? MSW 2015-04-18 Include sub-circuit components in Components list
//  PnlLblTxt   m_oTxtBinGschem;   // ??? MSW 2014-03-11 Allow binary names to be specified
//  PnlLblTxt   m_oTxtBinGnetlst;
//  PnlLblTxt   m_oTxtBinNgspice;
//  PnlLblTxt   m_oTxtBinGnucap;
//  PnlLblTxt   m_oTxtBinGaw;
//  PnlLblTxt   m_oTxtBinGwave;
//  PnlLblTxt   m_oTxtBinCalc;
//  PnlLblTxt   m_oTxtDocNgSpice;
//  PnlLblTxt   m_oTxtDocGnuCap;

    // Button controls
    wxButton    m_oBtnOk;
    wxButton    m_oBtnCancel;

    // Object initialization functions
    void  Initialize( void );
    void  Create    ( void );
    void  ToolTips  ( void );
    void  DoLayout  ( void );

    void  Load( void );
    void  Save( void );

  public :

          DlgPrefs( wxWindow * poWin );
         ~DlgPrefs( );

    bool  bClear( void );

    const  wxString  rosGetViewerUtil ( void )
                                      { return( m_oChoViewerUtil.m_oChoice.GetStringSelection() ); }
           int         iGetTmpFileMgt ( void )
                                      { return( m_oChoTmpFileMgt.m_oChoice.GetSelection( ) ); }
           int         iGetFrmLayout  ( void )
                                      { return( m_oChoFrmLayout .m_oChoice.GetSelection( ) ); }
           int         iGetUnitsPhase ( void )
                                      { return( m_oChoUnitsPhase.m_oChoice.GetSelection( ) ); }
           int         iGetPrecision  ( void )
                                      { return( m_oChoPrecision .m_oChoice.GetSelection( ) + 1 ); }
           int         iGetNbkMaxLns  ( void )
                                      { return( (int) m_oPnlNbkMaxLns.liGetValue( ) ); }
           int         iGetSpnPeriod  ( void )
                                      { return( (int) (1000.0 * m_oPnlSpnPeriod.dfGetValue( )) ); }
//         int         iGetTipDelay   ( void ) // ??? MSW 2015-03-23
//                                    { return( m_oPnlTipDelay .liGetValue( ) ); }
           bool        bGetSyncSwpSrcs( void )
                                      { return( m_oCbxSyncSwpSrcs.IsChecked( ) ); }
           bool        bGetToolTips   ( void )
                                      { return( m_oCbxToolTips   .IsChecked( ) ); }

  private :

    // Event handlers
    void  OnBtnOk    ( wxCommandEvent & roEvtCmd );
    void  OnBtnCancel( wxCommandEvent & roEvtCmd );

    friend  class  FrmMain;

    // In order to be able to react to a menu command, it must be given a unique identifier such as
    // a const or an enum.
    enum eDlgItemID
    {
      ID_CHO_SIMENG,
      ID_CHO_VIEWERUTIL,
      ID_CHO_TMPFILEMGT,
      ID_CHO_FRMLAYOUT,
      ID_CHO_PHASEUNITS,
      ID_CHO_PRECISION,

      ID_VAL_NBKMAXLNS,
      ID_VAL_SPINPERIOD,
//      ID_VAL_TIPDELAY, // ??? MSW 2015-03-23

      ID_CBX_SYNCSWPSRCS,
      ID_CBX_TOOLTIPS,

      ID_TXT_GSCHEM,
      ID_TXT_GNETLST,
      ID_TXT_NGSPICE,
      ID_TXT_GNUCAP,
      ID_TXT_GAW,
      ID_TXT_GWAVE,
      ID_TXT_CALC,

      ID_BTN_OK,
      ID_BTN_CANCEL,

      ID_UNUSED,      // Assigned to controls for which events are not used

      ID_FST = ID_CHO_SIMENG,
      ID_LST = ID_BTN_CANCEL
    };

    // Leave this as the last line as private access is envoked by macro
    wxDECLARE_EVENT_TABLE( );
};

//**************************************************************************************************

#endif // DLGPREFS_HPP
