/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// NatGatewayEntities struct for NatGatewayEntities
type NatGatewayEntities struct {
	Rules    *NatGatewayRules `json:"rules,omitempty"`
	Flowlogs *FlowLogs        `json:"flowlogs,omitempty"`
}

// NewNatGatewayEntities instantiates a new NatGatewayEntities object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewNatGatewayEntities() *NatGatewayEntities {
	this := NatGatewayEntities{}

	return &this
}

// NewNatGatewayEntitiesWithDefaults instantiates a new NatGatewayEntities object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewNatGatewayEntitiesWithDefaults() *NatGatewayEntities {
	this := NatGatewayEntities{}
	return &this
}

// GetRules returns the Rules field value
// If the value is explicit nil, the zero value for NatGatewayRules will be returned
func (o *NatGatewayEntities) GetRules() *NatGatewayRules {
	if o == nil {
		return nil
	}

	return o.Rules

}

// GetRulesOk returns a tuple with the Rules field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NatGatewayEntities) GetRulesOk() (*NatGatewayRules, bool) {
	if o == nil {
		return nil, false
	}

	return o.Rules, true
}

// SetRules sets field value
func (o *NatGatewayEntities) SetRules(v NatGatewayRules) {

	o.Rules = &v

}

// HasRules returns a boolean if a field has been set.
func (o *NatGatewayEntities) HasRules() bool {
	if o != nil && o.Rules != nil {
		return true
	}

	return false
}

// GetFlowlogs returns the Flowlogs field value
// If the value is explicit nil, the zero value for FlowLogs will be returned
func (o *NatGatewayEntities) GetFlowlogs() *FlowLogs {
	if o == nil {
		return nil
	}

	return o.Flowlogs

}

// GetFlowlogsOk returns a tuple with the Flowlogs field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NatGatewayEntities) GetFlowlogsOk() (*FlowLogs, bool) {
	if o == nil {
		return nil, false
	}

	return o.Flowlogs, true
}

// SetFlowlogs sets field value
func (o *NatGatewayEntities) SetFlowlogs(v FlowLogs) {

	o.Flowlogs = &v

}

// HasFlowlogs returns a boolean if a field has been set.
func (o *NatGatewayEntities) HasFlowlogs() bool {
	if o != nil && o.Flowlogs != nil {
		return true
	}

	return false
}

func (o NatGatewayEntities) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Rules != nil {
		toSerialize["rules"] = o.Rules
	}
	if o.Flowlogs != nil {
		toSerialize["flowlogs"] = o.Flowlogs
	}
	return json.Marshal(toSerialize)
}

type NullableNatGatewayEntities struct {
	value *NatGatewayEntities
	isSet bool
}

func (v NullableNatGatewayEntities) Get() *NatGatewayEntities {
	return v.value
}

func (v *NullableNatGatewayEntities) Set(val *NatGatewayEntities) {
	v.value = val
	v.isSet = true
}

func (v NullableNatGatewayEntities) IsSet() bool {
	return v.isSet
}

func (v *NullableNatGatewayEntities) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableNatGatewayEntities(val *NatGatewayEntities) *NullableNatGatewayEntities {
	return &NullableNatGatewayEntities{value: val, isSet: true}
}

func (v NullableNatGatewayEntities) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableNatGatewayEntities) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
