package emulation

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"

	"github.com/mailru/easyjson"
	"github.com/mailru/easyjson/jlexer"
	"github.com/mailru/easyjson/jwriter"
)

// ScreenOrientation screen orientation.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Emulation#type-ScreenOrientation
type ScreenOrientation struct {
	Type  OrientationType `json:"type"`  // Orientation type.
	Angle int64           `json:"angle"` // Orientation angle.
}

// DisplayFeature [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Emulation#type-DisplayFeature
type DisplayFeature struct {
	Orientation DisplayFeatureOrientation `json:"orientation"` // Orientation of a display feature in relation to screen
	Offset      int64                     `json:"offset"`      // The offset from the screen origin in either the x (for vertical orientation) or y (for horizontal orientation) direction.
	MaskLength  int64                     `json:"maskLength"`  // A display feature may mask content such that it is not physically displayed - this length along with the offset describes this area. A display feature that only splits content will have a 0 mask_length.
}

// MediaFeature [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Emulation#type-MediaFeature
type MediaFeature struct {
	Name  string `json:"name"`
	Value string `json:"value"`
}

// VirtualTimePolicy advance: If the scheduler runs out of immediate work,
// the virtual time base may fast forward to allow the next delayed task (if
// any) to run; pause: The virtual time base may not advance;
// pauseIfNetworkFetchesPending: The virtual time base may not advance if there
// are any pending resource fetches.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Emulation#type-VirtualTimePolicy
type VirtualTimePolicy string

// String returns the VirtualTimePolicy as string value.
func (t VirtualTimePolicy) String() string {
	return string(t)
}

// VirtualTimePolicy values.
const (
	VirtualTimePolicyAdvance                      VirtualTimePolicy = "advance"
	VirtualTimePolicyPause                        VirtualTimePolicy = "pause"
	VirtualTimePolicyPauseIfNetworkFetchesPending VirtualTimePolicy = "pauseIfNetworkFetchesPending"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t VirtualTimePolicy) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t VirtualTimePolicy) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *VirtualTimePolicy) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch VirtualTimePolicy(v) {
	case VirtualTimePolicyAdvance:
		*t = VirtualTimePolicyAdvance
	case VirtualTimePolicyPause:
		*t = VirtualTimePolicyPause
	case VirtualTimePolicyPauseIfNetworkFetchesPending:
		*t = VirtualTimePolicyPauseIfNetworkFetchesPending

	default:
		in.AddError(fmt.Errorf("unknown VirtualTimePolicy value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *VirtualTimePolicy) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// UserAgentBrandVersion used to specify User Agent Cient Hints to emulate.
// See https://wicg.github.io/ua-client-hints.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Emulation#type-UserAgentBrandVersion
type UserAgentBrandVersion struct {
	Brand   string `json:"brand"`
	Version string `json:"version"`
}

// UserAgentMetadata used to specify User Agent Cient Hints to emulate. See
// https://wicg.github.io/ua-client-hints Missing optional values will be filled
// in by the target with what it would normally use.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Emulation#type-UserAgentMetadata
type UserAgentMetadata struct {
	Brands          []*UserAgentBrandVersion `json:"brands,omitempty"`
	FullVersionList []*UserAgentBrandVersion `json:"fullVersionList,omitempty"`
	Platform        string                   `json:"platform"`
	PlatformVersion string                   `json:"platformVersion"`
	Architecture    string                   `json:"architecture"`
	Model           string                   `json:"model"`
	Mobile          bool                     `json:"mobile"`
	Bitness         string                   `json:"bitness,omitempty"`
	Wow64           bool                     `json:"wow64,omitempty"`
}

// DisabledImageType enum of image types that can be disabled.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Emulation#type-DisabledImageType
type DisabledImageType string

// String returns the DisabledImageType as string value.
func (t DisabledImageType) String() string {
	return string(t)
}

// DisabledImageType values.
const (
	DisabledImageTypeAvif DisabledImageType = "avif"
	DisabledImageTypeWebp DisabledImageType = "webp"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t DisabledImageType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t DisabledImageType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *DisabledImageType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch DisabledImageType(v) {
	case DisabledImageTypeAvif:
		*t = DisabledImageTypeAvif
	case DisabledImageTypeWebp:
		*t = DisabledImageTypeWebp

	default:
		in.AddError(fmt.Errorf("unknown DisabledImageType value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *DisabledImageType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// OrientationType orientation type.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Emulation#type-ScreenOrientation
type OrientationType string

// String returns the OrientationType as string value.
func (t OrientationType) String() string {
	return string(t)
}

// OrientationType values.
const (
	OrientationTypePortraitPrimary    OrientationType = "portraitPrimary"
	OrientationTypePortraitSecondary  OrientationType = "portraitSecondary"
	OrientationTypeLandscapePrimary   OrientationType = "landscapePrimary"
	OrientationTypeLandscapeSecondary OrientationType = "landscapeSecondary"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t OrientationType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t OrientationType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *OrientationType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch OrientationType(v) {
	case OrientationTypePortraitPrimary:
		*t = OrientationTypePortraitPrimary
	case OrientationTypePortraitSecondary:
		*t = OrientationTypePortraitSecondary
	case OrientationTypeLandscapePrimary:
		*t = OrientationTypeLandscapePrimary
	case OrientationTypeLandscapeSecondary:
		*t = OrientationTypeLandscapeSecondary

	default:
		in.AddError(fmt.Errorf("unknown OrientationType value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *OrientationType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// DisplayFeatureOrientation orientation of a display feature in relation to
// screen.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Emulation#type-DisplayFeature
type DisplayFeatureOrientation string

// String returns the DisplayFeatureOrientation as string value.
func (t DisplayFeatureOrientation) String() string {
	return string(t)
}

// DisplayFeatureOrientation values.
const (
	DisplayFeatureOrientationVertical   DisplayFeatureOrientation = "vertical"
	DisplayFeatureOrientationHorizontal DisplayFeatureOrientation = "horizontal"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t DisplayFeatureOrientation) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t DisplayFeatureOrientation) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *DisplayFeatureOrientation) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch DisplayFeatureOrientation(v) {
	case DisplayFeatureOrientationVertical:
		*t = DisplayFeatureOrientationVertical
	case DisplayFeatureOrientationHorizontal:
		*t = DisplayFeatureOrientationHorizontal

	default:
		in.AddError(fmt.Errorf("unknown DisplayFeatureOrientation value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *DisplayFeatureOrientation) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// SetEmitTouchEventsForMouseConfiguration touch/gesture events
// configuration. Default: current platform.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Emulation#method-setEmitTouchEventsForMouse
type SetEmitTouchEventsForMouseConfiguration string

// String returns the SetEmitTouchEventsForMouseConfiguration as string value.
func (t SetEmitTouchEventsForMouseConfiguration) String() string {
	return string(t)
}

// SetEmitTouchEventsForMouseConfiguration values.
const (
	SetEmitTouchEventsForMouseConfigurationMobile  SetEmitTouchEventsForMouseConfiguration = "mobile"
	SetEmitTouchEventsForMouseConfigurationDesktop SetEmitTouchEventsForMouseConfiguration = "desktop"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t SetEmitTouchEventsForMouseConfiguration) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t SetEmitTouchEventsForMouseConfiguration) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *SetEmitTouchEventsForMouseConfiguration) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch SetEmitTouchEventsForMouseConfiguration(v) {
	case SetEmitTouchEventsForMouseConfigurationMobile:
		*t = SetEmitTouchEventsForMouseConfigurationMobile
	case SetEmitTouchEventsForMouseConfigurationDesktop:
		*t = SetEmitTouchEventsForMouseConfigurationDesktop

	default:
		in.AddError(fmt.Errorf("unknown SetEmitTouchEventsForMouseConfiguration value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *SetEmitTouchEventsForMouseConfiguration) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// SetEmulatedVisionDeficiencyType vision deficiency to emulate.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Emulation#method-setEmulatedVisionDeficiency
type SetEmulatedVisionDeficiencyType string

// String returns the SetEmulatedVisionDeficiencyType as string value.
func (t SetEmulatedVisionDeficiencyType) String() string {
	return string(t)
}

// SetEmulatedVisionDeficiencyType values.
const (
	SetEmulatedVisionDeficiencyTypeNone          SetEmulatedVisionDeficiencyType = "none"
	SetEmulatedVisionDeficiencyTypeAchromatopsia SetEmulatedVisionDeficiencyType = "achromatopsia"
	SetEmulatedVisionDeficiencyTypeBlurredVision SetEmulatedVisionDeficiencyType = "blurredVision"
	SetEmulatedVisionDeficiencyTypeDeuteranopia  SetEmulatedVisionDeficiencyType = "deuteranopia"
	SetEmulatedVisionDeficiencyTypeProtanopia    SetEmulatedVisionDeficiencyType = "protanopia"
	SetEmulatedVisionDeficiencyTypeTritanopia    SetEmulatedVisionDeficiencyType = "tritanopia"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t SetEmulatedVisionDeficiencyType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t SetEmulatedVisionDeficiencyType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *SetEmulatedVisionDeficiencyType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch SetEmulatedVisionDeficiencyType(v) {
	case SetEmulatedVisionDeficiencyTypeNone:
		*t = SetEmulatedVisionDeficiencyTypeNone
	case SetEmulatedVisionDeficiencyTypeAchromatopsia:
		*t = SetEmulatedVisionDeficiencyTypeAchromatopsia
	case SetEmulatedVisionDeficiencyTypeBlurredVision:
		*t = SetEmulatedVisionDeficiencyTypeBlurredVision
	case SetEmulatedVisionDeficiencyTypeDeuteranopia:
		*t = SetEmulatedVisionDeficiencyTypeDeuteranopia
	case SetEmulatedVisionDeficiencyTypeProtanopia:
		*t = SetEmulatedVisionDeficiencyTypeProtanopia
	case SetEmulatedVisionDeficiencyTypeTritanopia:
		*t = SetEmulatedVisionDeficiencyTypeTritanopia

	default:
		in.AddError(fmt.Errorf("unknown SetEmulatedVisionDeficiencyType value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *SetEmulatedVisionDeficiencyType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}
