// Code generated by smithy-go-codegen DO NOT EDIT.

package privatenetworks

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/privatenetworks/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists device identifiers. Add filters to your request to return a more specific
// list of results. Use filters to match the Amazon Resource Name (ARN) of an
// order, the status of device identifiers, or the ARN of the traffic group. If you
// specify multiple filters, filters are joined with an OR, and the request returns
// results that match all of the specified filters.
func (c *Client) ListDeviceIdentifiers(ctx context.Context, params *ListDeviceIdentifiersInput, optFns ...func(*Options)) (*ListDeviceIdentifiersOutput, error) {
	if params == nil {
		params = &ListDeviceIdentifiersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDeviceIdentifiers", params, optFns, c.addOperationListDeviceIdentifiersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDeviceIdentifiersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDeviceIdentifiersInput struct {

	// The Amazon Resource Name (ARN) of the network.
	//
	// This member is required.
	NetworkArn *string

	// The filters.
	//   - ORDER - The Amazon Resource Name (ARN) of the order.
	//   - STATUS - The status ( ACTIVE | INACTIVE ).
	//   - TRAFFIC_GROUP - The Amazon Resource Name (ARN) of the traffic group.
	// Filter values are case sensitive. If you specify multiple values for a filter,
	// the values are joined with an OR , and the request returns all results that
	// match any of the specified values.
	Filters map[string][]string

	// The maximum number of results to return.
	MaxResults *int32

	// The token for the next page of results.
	StartToken *string

	noSmithyDocumentSerde
}

type ListDeviceIdentifiersOutput struct {

	// Information about the device identifiers.
	DeviceIdentifiers []types.DeviceIdentifier

	// The token for the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDeviceIdentifiersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDeviceIdentifiers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDeviceIdentifiers{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDeviceIdentifiers"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListDeviceIdentifiersValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDeviceIdentifiers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDeviceIdentifiersAPIClient is a client that implements the
// ListDeviceIdentifiers operation.
type ListDeviceIdentifiersAPIClient interface {
	ListDeviceIdentifiers(context.Context, *ListDeviceIdentifiersInput, ...func(*Options)) (*ListDeviceIdentifiersOutput, error)
}

var _ ListDeviceIdentifiersAPIClient = (*Client)(nil)

// ListDeviceIdentifiersPaginatorOptions is the paginator options for
// ListDeviceIdentifiers
type ListDeviceIdentifiersPaginatorOptions struct {
	// The maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDeviceIdentifiersPaginator is a paginator for ListDeviceIdentifiers
type ListDeviceIdentifiersPaginator struct {
	options   ListDeviceIdentifiersPaginatorOptions
	client    ListDeviceIdentifiersAPIClient
	params    *ListDeviceIdentifiersInput
	nextToken *string
	firstPage bool
}

// NewListDeviceIdentifiersPaginator returns a new ListDeviceIdentifiersPaginator
func NewListDeviceIdentifiersPaginator(client ListDeviceIdentifiersAPIClient, params *ListDeviceIdentifiersInput, optFns ...func(*ListDeviceIdentifiersPaginatorOptions)) *ListDeviceIdentifiersPaginator {
	if params == nil {
		params = &ListDeviceIdentifiersInput{}
	}

	options := ListDeviceIdentifiersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDeviceIdentifiersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.StartToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDeviceIdentifiersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDeviceIdentifiers page.
func (p *ListDeviceIdentifiersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDeviceIdentifiersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.StartToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListDeviceIdentifiers(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListDeviceIdentifiers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDeviceIdentifiers",
	}
}
