// Code generated by smithy-go-codegen DO NOT EDIT.

package opensearch

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Allows you to purchase reserved OpenSearch instances.
func (c *Client) PurchaseReservedInstanceOffering(ctx context.Context, params *PurchaseReservedInstanceOfferingInput, optFns ...func(*Options)) (*PurchaseReservedInstanceOfferingOutput, error) {
	if params == nil {
		params = &PurchaseReservedInstanceOfferingInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PurchaseReservedInstanceOffering", params, optFns, c.addOperationPurchaseReservedInstanceOfferingMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PurchaseReservedInstanceOfferingOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Container for parameters to PurchaseReservedInstanceOffering
type PurchaseReservedInstanceOfferingInput struct {

	// A customer-specified identifier to track this reservation.
	//
	// This member is required.
	ReservationName *string

	// The ID of the reserved OpenSearch instance offering to purchase.
	//
	// This member is required.
	ReservedInstanceOfferingId *string

	// The number of OpenSearch instances to reserve.
	InstanceCount int32

	noSmithyDocumentSerde
}

// Represents the output of a PurchaseReservedInstanceOffering operation.
type PurchaseReservedInstanceOfferingOutput struct {

	// The customer-specified identifier used to track this reservation.
	ReservationName *string

	// Details of the reserved OpenSearch instance which was purchased.
	ReservedInstanceId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPurchaseReservedInstanceOfferingMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPurchaseReservedInstanceOffering{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPurchaseReservedInstanceOffering{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpPurchaseReservedInstanceOfferingValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPurchaseReservedInstanceOffering(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPurchaseReservedInstanceOffering(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "es",
		OperationName: "PurchaseReservedInstanceOffering",
	}
}
