// Code generated by smithy-go-codegen DO NOT EDIT.

package marketplacecatalog

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/marketplacecatalog/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCancelChangeSet struct {
}

func (*validateOpCancelChangeSet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelChangeSet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelChangeSetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelChangeSetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeChangeSet struct {
}

func (*validateOpDescribeChangeSet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeChangeSet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeChangeSetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeChangeSetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeEntity struct {
}

func (*validateOpDescribeEntity) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeEntity) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeEntityInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeEntityInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListChangeSets struct {
}

func (*validateOpListChangeSets) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListChangeSets) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListChangeSetsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListChangeSetsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListEntities struct {
}

func (*validateOpListEntities) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListEntities) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListEntitiesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListEntitiesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartChangeSet struct {
}

func (*validateOpStartChangeSet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartChangeSet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartChangeSetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartChangeSetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCancelChangeSetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelChangeSet{}, middleware.After)
}

func addOpDescribeChangeSetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeChangeSet{}, middleware.After)
}

func addOpDescribeEntityValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeEntity{}, middleware.After)
}

func addOpListChangeSetsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListChangeSets{}, middleware.After)
}

func addOpListEntitiesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListEntities{}, middleware.After)
}

func addOpStartChangeSetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartChangeSet{}, middleware.After)
}

func validateChange(v *types.Change) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Change"}
	if v.ChangeType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ChangeType"))
	}
	if v.Entity == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Entity"))
	} else if v.Entity != nil {
		if err := validateEntity(v.Entity); err != nil {
			invalidParams.AddNested("Entity", err.(smithy.InvalidParamsError))
		}
	}
	if v.Details == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Details"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEntity(v *types.Entity) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Entity"}
	if v.Type == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRequestedChangeList(v []types.Change) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RequestedChangeList"}
	for i := range v {
		if err := validateChange(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelChangeSetInput(v *CancelChangeSetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelChangeSetInput"}
	if v.Catalog == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Catalog"))
	}
	if v.ChangeSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ChangeSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeChangeSetInput(v *DescribeChangeSetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeChangeSetInput"}
	if v.Catalog == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Catalog"))
	}
	if v.ChangeSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ChangeSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeEntityInput(v *DescribeEntityInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeEntityInput"}
	if v.Catalog == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Catalog"))
	}
	if v.EntityId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EntityId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListChangeSetsInput(v *ListChangeSetsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListChangeSetsInput"}
	if v.Catalog == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Catalog"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListEntitiesInput(v *ListEntitiesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListEntitiesInput"}
	if v.Catalog == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Catalog"))
	}
	if v.EntityType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EntityType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartChangeSetInput(v *StartChangeSetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartChangeSetInput"}
	if v.Catalog == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Catalog"))
	}
	if v.ChangeSet == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ChangeSet"))
	} else if v.ChangeSet != nil {
		if err := validateRequestedChangeList(v.ChangeSet); err != nil {
			invalidParams.AddNested("ChangeSet", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
