# The Pikchr Diagram Language

Pikchr (pronounced "picture") is a [PIC][1]-like markup language for creating
diagrams in technical documentation.  Source text for Pikchr diagrams 
can be embedded directly in either [Markdown][2] or [Fossil Wiki][3].
Fossil translates the Pikchr source text into SVG which is displayed as
part of the rendered wiki.

[1]: wikipedia:/wiki/Pic_language
[2]: /md_rules
[3]: /wiki_rules

For example, this document is written in Markdown.  The following
is a sample Pikchr diagram:

``` pikchr
arrow right 200% "Markdown" "Source"
box rad 10px "Markdown" "Formatter" "(markdown.c)" fit
arrow right 200% "HTML+SVG" "Output"
arrow <-> down 70% from last box.s
box same "Pikchr" "Formatter" "(pikchr.c)" fit
```

The diagram above was generated by the following lines of Markdown:

~~~~~
``` pikchr
arrow right 200% "Markdown" "Source"
box rad 10px "Markdown" "Formatter" "(markdown.c)" fit
arrow right 200% "HTML+SVG" "Output"
arrow <-> down 70% from last box.s
box same "Pikchr" "Formatter" "(pikchr.c)" fit
```
~~~~~

See the [original Markdown source text of this document][4] for an
example of Pikchr in operation.  

[4]: ./pikchr.md?mimetype=text/plain

Fossil allows Pikchr diagrams to appear anywhere that Markdown or
Fossil Wiki markup or used, including:

   *  [Embedded documentation](./embeddeddoc.wiki)
   *  Stand-alone wiki pages
   *  [Wiki pages associated with particular branches or check-ins](./wikitheory.wiki#assocwiki)
   *  Check-in comments
   *  [Technical notes](./event.wiki)
   *  [Forum posts](./forum.wiki)
   *  [Bug reports and trouble tickets](./bugtheory.wiki)

## Pikchr Is A Separate Project

Even though the original author of Pikchr is the same as the original
creator of Fossil, the sources to the Pikchr formatter are maintained
as a [separate project named "pikchr.org"](https://pikchr.org).
Pikchr is a delivered as a single file of C code.  The "pikchr.c" file
from the Pikchr project is periodically copied into the Fossil source
tree.  Pikchr is maintained as a project distinct from Fossil so that it
can be used independently of Fossil.

### Pikchr User Manual And Tutorials

Complete documentation on the Pikchr language can be found on the
Pikchr project page:

   *  <https://pikchr.org/>

That website contains a user manual, tutorials, a language specification,
a summary of differences between Pikchr and legacy PIC,
and it hosts copies of historical PIC documentation.

## How To Include Pikchr Diagrams In Fossil Documents

To illustrate how to include Pikchr in Fossil markup, we will use the
following one-line Pikchr.  Click to see the code:

~~~ pikchr toggle
arrow; box "Hello" "World!" fit; arrow
~~~

For Markdown, the Pikchr code is put inside of a
[fenced code block][fcb].  A fenced code block is the text in between
&#96;&#96;&#96; ... &#96;&#96;&#96; or between
&#126;&#126;&#126; ... &#126;&#126;&#126; using three or
more &#96; or &#126; characters.  The fenced code block normally
displays its content verbatim, but if an "info string"  of "pikchr"
follows the opening &#96;&#96;&#96; or &#126;&#126;&#126;, then the
content is interpreted as Pikchr script and is replaced by the
equivalent SVG.
So either of these work:

[fcb]: https://spec.commonmark.org/0.29/#fenced-code-blocks

~~~~~~
~~~ pikchr
arrow; box "Hello" "World!" fit; arrow
~~~

``` pikchr
arrow; box "Hello" "World!" fit; arrow
```
~~~~~~

For Fossil Wiki, the Pikchr code goes within 
`<verbatim type="pikchr"> ... </verbatim>`.  Normally `<verbatim>`
content is displayed verbatim.  The extra `type="pikchr"` attribute
causes the content to be interpreted as Pikchr and replaced by SVG.

~~~~~~
<verbatim type="pikchr">
arrow; box "Hello" "World!" fit; arrow
</verbatim>
~~~~~~

## Extra Arguments In "Pikchr" Code Blocks

Extra formatting arguments can be included in the fenced code block start
tag, or in the "`type=`" attribute of `<verbatim>`, to change the formatting
of the diagram.

  *  **indent**  &rarr;  The diagram is indented from the left margin.

  *  **center**  &rarr;  The diagram is centered

  *  **toggle**  &rarr;  Clicking on the diagram toggles between showing
     the rendered SVG and the original Pikchr source text.  You can always
     do this by holding down the Ctrl or Alt keys and clicking.  The
     "toggle" option just means you can toggle without holding down any
     extra keys.

  *  **float-left** &rarr;  The diagram is shown at the left margin and
     text fills in around the diagram.

  *  **float-right** &rarr;  The diagram is shown at the right margin and
     text fills in around the diagram.

  *  **source** &rarr;  The display starts out showing the Pikchr source text.
     The reader must click (or Alt-click or Ctrl-click) to show the diagram.
