*** Settings ***

Resource            ${CURDIR}${/}..${/}..${/}..${/}..${/}resources/import.resource

Test Timeout        120s
Test Setup          Ctn Generic Suite Setup

*** Variables ***
${CMD}      ${CENTREON_PLUGINS} --plugin=network::aruba::aoscx::snmp::plugin

*** Test Cases ***
interfaces ${tc}
    [Tags]    network    aruba    interfaces
    ${command}    Catenate
    ...    ${CMD}
    ...    --mode=interfaces
    ...    --hostname=${HOSTNAME}
    ...    --snmp-version=${SNMPVERSION}
    ...    --snmp-port=${SNMPPORT}
    ...    --snmp-community=network/aruba/aoscx/snmp/slim_aoscx-spanning-tree
    ...    --snmp-timeout=1
    ...    ${extra_options}
 
    Ctn Run Command And Check Result As Strings    ${command}    ${expected_result}

    Examples:        tc    extra_options                                                                                                           expected_result    --
            ...      1     ${EMPTY}                                                                                                                CRITICAL: Interface '1/1/10' Status : down (admin: up) - Interface '1/1/11' Status : down (admin: up) - Interface '1/1/12' Status : down (admin: up) - Interface '1/1/13' Status : down (admin: up) - Interface '1/1/14' Status : down (admin: up) - Interface '1/1/2' Status : down (admin: up) - Interface '1/1/4' Status : down (admin: up) - Interface '1/1/5' Status : down (admin: up) - Interface '1/1/6' Status : down (admin: up) - Interface '1/1/7' Status : down (admin: up) - Interface '1/1/8' Status : down (admin: up) - Interface '1/1/9' Status : down (admin: up)
            ...      2     --add-global                                                                                                            OK: Total port : 18, AdminStatus Up : 18, AdminStatus Down : 0, OperStatus Up : 6, OperStatus Down : 12 | 'total_port'=18;;;0;18 'total_admin_up'=18;;;0;18 'total_admin_down'=0;;;0;18 'total_oper_up'=6;;;0;18 'global_oper_down'=12;;;0;18
            ...      3     --add-status                                                                                                            CRITICAL: Interface '1/1/10' Status : down (admin: up) - Interface '1/1/11' Status : down (admin: up) - Interface '1/1/12' Status : down (admin: up) - Interface '1/1/13' Status : down (admin: up) - Interface '1/1/14' Status : down (admin: up) - Interface '1/1/2' Status : down (admin: up) - Interface '1/1/4' Status : down (admin: up) - Interface '1/1/5' Status : down (admin: up) - Interface '1/1/6' Status : down (admin: up) - Interface '1/1/7' Status : down (admin: up) - Interface '1/1/8' Status : down (admin: up) - Interface '1/1/9' Status : down (admin: up)
            ...      4     --add-duplex-status --warning-status='\\\%{opstatus} eq "warning"'                                                      CRITICAL: Interface '1/1/10' Status : down (admin: up) (duplex: fullDuplex) - Interface '1/1/11' Status : down (admin: up) (duplex: fullDuplex) - Interface '1/1/12' Status : down (admin: up) (duplex: fullDuplex) - Interface '1/1/13' Status : down (admin: up) (duplex: fullDuplex) - Interface '1/1/14' Status : down (admin: up) (duplex: fullDuplex) - Interface '1/1/2' Status : down (admin: up) (duplex: fullDuplex) - Interface '1/1/4' Status : down (admin: up) (duplex: fullDuplex) - Interface '1/1/5' Status : down (admin: up) (duplex: fullDuplex) - Interface '1/1/6' Status : down (admin: up) (duplex: fullDuplex) - Interface '1/1/7' Status : down (admin: up) (duplex: fullDuplex) - Interface '1/1/8' Status : down (admin: up) (duplex: fullDuplex) - Interface '1/1/9' Status : down (admin: up) (duplex: fullDuplex)
            ...      5     --add-traffic --name --interface='Anonymized 123' --warning-in-traffic=1:1 --speed=1                                    UNKNOWN: No entry found (maybe you should reload cache file)
            ...      6     --add-errors                                                                                                            OK: All interfaces are ok
            ...      7     --add-cast --interface='1,1,14'                                                                                         OK: All interfaces are ok
            ...      8     --add-speed --interface='1,1,16'                                                                                        OK: All interfaces are ok | 'speed_1/1/1'=100000000b/s;;;0; 'speed_1/1/16'=1000000000b/s;;;0;
            ...      9     --add-volume --interface='1,1,10' --add-status='critical'                                                               CRITICAL: Interface '1/1/10' Status : down (admin: up)
            ...      10    --check-metrics='\\\%{opstatus} eq "up"'                                                                                CRITICAL: Interface '1/1/10' Status : down (admin: up) - Interface '1/1/11' Status : down (admin: up) - Interface '1/1/12' Status : down (admin: up) - Interface '1/1/13' Status : down (admin: up) - Interface '1/1/14' Status : down (admin: up) - Interface '1/1/2' Status : down (admin: up) - Interface '1/1/4' Status : down (admin: up) - Interface '1/1/5' Status : down (admin: up) - Interface '1/1/6' Status : down (admin: up) - Interface '1/1/7' Status : down (admin: up) - Interface '1/1/8' Status : down (admin: up) - Interface '1/1/9' Status : down (admin: up)
            ...      11    --warning-status='\\\%{admstatus} eq "up"' --interface='16'                                                             WARNING: Interface '1/1/16' Status : up (admin: up)
            ...      12    --critical-status='\\\%{admstatus} eq "up" and \\\%{opstatus} ne "up"'                                                  CRITICAL: Interface '1/1/10' Status : down (admin: up) - Interface '1/1/11' Status : down (admin: up) - Interface '1/1/12' Status : down (admin: up) - Interface '1/1/13' Status : down (admin: up) - Interface '1/1/14' Status : down (admin: up) - Interface '1/1/2' Status : down (admin: up) - Interface '1/1/4' Status : down (admin: up) - Interface '1/1/5' Status : down (admin: up) - Interface '1/1/6' Status : down (admin: up) - Interface '1/1/7' Status : down (admin: up) - Interface '1/1/8' Status : down (admin: up) - Interface '1/1/9' Status : down (admin: up)
            ...      13    --warning-out-traffic='0' --critical-out-traffic=10 --warning-status='\\\%{opstatus} eq "up"' --interface='16'          WARNING: Interface '1/1/16' Status : up (admin: up)
            ...      14    --warning-in-traffic='0' --critical-in-traffic=10 --critical-status='\\\%{opstatus} eq "up"'                            CRITICAL: Interface '1/1/1' Status : up (admin: up) - Interface '1/1/15' Status : up (admin: up) - Interface '1/1/16' Status : up (admin: up) - Interface 'Anonymized 124' Status : up (admin: up) - Interface '1/1/3' Status : up (admin: up) - Interface 'Anonymized 066' Status : up (admin: up)
            ...      15    --units-traffic='12%'                                                                                                   CRITICAL: Interface '1/1/10' Status : down (admin: up) - Interface '1/1/11' Status : down (admin: up) - Interface '1/1/12' Status : down (admin: up) - Interface '1/1/13' Status : down (admin: up) - Interface '1/1/14' Status : down (admin: up) - Interface '1/1/2' Status : down (admin: up) - Interface '1/1/4' Status : down (admin: up) - Interface '1/1/5' Status : down (admin: up) - Interface '1/1/6' Status : down (admin: up) - Interface '1/1/7' Status : down (admin: up) - Interface '1/1/8' Status : down (admin: up) - Interface '1/1/9' Status : down (admin: up)
            ...      16    --units-errors='12%'                                                                                                    CRITICAL: Interface '1/1/10' Status : down (admin: up) - Interface '1/1/11' Status : down (admin: up) - Interface '1/1/12' Status : down (admin: up) - Interface '1/1/13' Status : down (admin: up) - Interface '1/1/14' Status : down (admin: up) - Interface '1/1/2' Status : down (admin: up) - Interface '1/1/4' Status : down (admin: up) - Interface '1/1/5' Status : down (admin: up) - Interface '1/1/6' Status : down (admin: up) - Interface '1/1/7' Status : down (admin: up) - Interface '1/1/8' Status : down (admin: up) - Interface '1/1/9' Status : down (admin: up)
            ...      17    --units-cast='12%'                                                                                                      CRITICAL: Interface '1/1/10' Status : down (admin: up) - Interface '1/1/11' Status : down (admin: up) - Interface '1/1/12' Status : down (admin: up) - Interface '1/1/13' Status : down (admin: up) - Interface '1/1/14' Status : down (admin: up) - Interface '1/1/2' Status : down (admin: up) - Interface '1/1/4' Status : down (admin: up) - Interface '1/1/5' Status : down (admin: up) - Interface '1/1/6' Status : down (admin: up) - Interface '1/1/7' Status : down (admin: up) - Interface '1/1/8' Status : down (admin: up) - Interface '1/1/9' Status : down (admin: up)
            ...      18    --display-transform-src='Anonymized' --display-transform-dst='Interface' --name --interface='Anonymized 124'            OK: Interface 'Interface 124' Status : up (admin: up)